#copyright Goh Chun Hee; www.1001bit.com

require 'sketchup.rb'
require 'extensions.rb'


#===============================================================
# Some default path for 1001bit folder in Windows and Mac are listed below
# Delete the '#' in front of the path you prefer to define the path
# You can edit the paths using a text editor. 
# If your 1001bit folder is in some specific location, for example F:/abc/1001bit
#Just replace the 'c:/your prefered path' with your specific path location.
# If no specific path is defined, the following scripts will assume that the 
# path to 1001bit under the plugins folder, i.e. where this file is located.
# If all fails, the script then hardcode the location to C:\1001bit
#===============================================================

#$GH1001pro_path='C:/Program Files/Google/Google SketchUp 6/Plugins/1001bit_pro'
#$GH1001pro_path='C:/Program Files/Google/Google SketchUp 7/Plugins/1001bit_pro'
#$GH1001pro_path='/Library/Application Support/Google Sketchup 6/SketchUp/plugins/1001bit_pro'
#$GH1001pro_path='/Library/Application Support/Google Sketchup 7/SketchUp/plugins/1001bit_pro'

#$GH1001pro_path='c:/your prefered path/1001bit_pro'


#================================================================
# set default location of 1001bit folder to be similar with this file, i.e. inside the Plugins folder 
if !($GH1001pro_path)
  filep=__FILE__  
  fa=filep.split('/')
  fa.pop
  $GH1001pro_path=fa.join('/')
  $GH1001pro_path = $GH1001pro_path + '/1001bit_pro'
end

# check to see if the menu file exists.
if File.exist?($GH1001pro_path + '/1001pro_loader.rb')
  
  #do nothing if path is correct and 1001bitmenu.rbs file is found

else
  
  #if the 1001bitmenu.rbs file cannot be found, rebuild the path
  filep=__FILE__  
  fa=filep.split('/')
  fa.pop
  $GH1001pro_path=fa.join('/')
  $GH1001pro_path = $GH1001pro_path + '/1001bit_pro'
  
  #try again to see whether the menu file can be found
  if File.exist?($GH1001pro_path + '/1001pro_loader.rb')
    
    #do nothing if the file is found
    
  else
    
    #still cannot find the 1001bitmenu file; set the path to default at c:/1001bit
    $GH1001pro_path="c:/1001bit_pro"
    
  end
end

if File.exist?($GH1001pro_path + '/1001pro_loader.rb')

#------------------------------------------------------------------------------------------------------
#setting up 1001bt tools as extensions

mytools = SketchupExtension.new "1001bit pro", $GH1001pro_path + "/1001pro_loader.rb"
mytools.description="Plugins for architectural works from www.1001bit.com"
mytools.copyright="Goh Chun Hee, www.1001bit.com"
mytools.creator="Goh Chun Hee, GohCH"
mytools.version="Pro 2"

Sketchup.register_extension mytools, true

else
  UI.messagebox "1001bit setup error -- cannot find #{$GH1001pro_path}/1001pro_loader.rb file"
end
